clear all, clc

%add folder path and filename
myfolder='C:\Users\Jakob Rentsch\box.fu\Papers\Stripes\figure S5\Simulation_images\cm_rainbow\stripy';
filename='stripy';
pixelsize=500/424; %in nm

%load file in
A=readmatrix([myfolder,'/',filename,'.csv']);
B=autocorr(A(:,2),length(A(:,2))-1);

%find local maxima
%define minimal distance between maximas (in px)
%F=islocalmax(B);

%filter out values if loca maxima
%C=[(1:length(B)).',F(:,1)];

%for n=1:length(C(:,1));
%  if B(n)<0;
%   C(n,2)=0;
%   else
%  end
%  end

%D=C(:,1);
%E=D(C(:,2)==1,:);
%peaks=E*pixelsize;

%calculate difference between maxima
%F=diff(E)*pixelsize;

%calculate mean distance
%G=mean(F)
%H=std(F)

%comments for graph titel
%comn = ['n=',num2str(numel(F))];
%commean= ['mean=',num2str(G),' ','+-',' ',num2str(H),' ', 'nm'];
compixelsize=['pixelsize=', num2str(pixelsize),' ', 'nm'];

%subplot(2,1,2)
%make histogramm
%k=(numel(F))^0.5;
%hist(F,k);
%xlabel('Distance between rings');
%ylabel('Counts');
%title({'Histogram of distance between rings',comn,commean,compixelsize});
 
%for n=1:length(C(:,1));
   %if C(n,2)==1;
   %C(n,2)=B(n);
 % elseif C(n,2)==0;
    %C(n,2)=NaN;
  % else
  % end
%end

%subplot(2,1,1)
plot([1:length(B)]'*pixelsize,B(:,1));
hold on
%scatter(C(:,1)*pixelsize,C(:,2))
set(gca,'fontname','arial')
hold off;
xlabel('Lag (nm)');
ylabel('ACF (a.u.)');
ylim([-0.5, 1])
xlim([0,1000])
xticks(0:200:1000)
title({'Autocorrelation of SPT'});

set(gca,'FontSize', 15)

%save figure to path
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.png']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.fig']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.pdf']))

%saveas(figure(1),fullfile(myfolder,[filename,'_','histogram of distance between rings','_',compixelsize,'_',comn,'_',commean,'.png']))
%saveas(figure(1),fullfile(myfolder,[filename,'_','histogram of distance between rings','_',compixelsize,'_',comn,'_',commean,'.fig']))

%save .csv to path
G=[[1:length(B)]'*pixelsize,B(:,1)];

dlmwrite(fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.csv']),G);

disp('Done');